# Installation and Setup

This guide will help you set up the environment for the Lion Circuits Hardware Hackathon 2.0 project.

## Prerequisites

- **Python 3.8+**: Ensure you have Python installed. You can check with `python3 --version`.
- **OpenAI API Key**: Required for the LLM Interaction API to function.

## Project Structure

The project consists of three main components:
1. **simulated_time_and_sensor_APIs**: Provides simulated sensor data and time.
2. **LLM_Interaction_APIs**: Handles communication with OpenAI and manages conversation history.
3. **Dashboard**: The frontend web interface for monitoring.

## Step-by-Step Installation

It is recommended to set up a virtual environment for each component to manage dependencies cleanly.

### 1. Simulated Time and Sensor APIs

Navigate to the directory:
```bash
cd simulated_time_and_sensor_APIs
```

Create and activate a virtual environment:
```bash
python3 -m venv venv
source venv/bin/activate  # On Windows use `venv\Scripts\activate`
```

Install dependencies:
```bash
pip install -r requirements.txt
```

### 2. LLM Interaction APIs

Open a new terminal window (or deactivate the previous environment).
Navigate to the directory:
```bash
cd LLM_Interaction_APIs
```

Create and activate a virtual environment:
```bash
python3 -m venv venv
source venv/bin/activate
```

Install dependencies:
```bash
pip install -r requirements.txt
```

**Configuration**:
You need to set your OpenAI API Key as an environment variable.
```bash
export OPENAI_API_KEY="your-api-key-here"
```
*(On Windows, use `set OPENAI_API_KEY=your-api-key-here`)*

### 3. Dashboard

Open a new terminal window.
Navigate to the directory:
```bash
cd Dashboard
```

Create and activate a virtual environment:
```bash
python3 -m venv venv
source venv/bin/activate
```

Install dependencies:
```bash
pip install -r requirements.txt
```

---
**Next Steps**: Once installation is complete, proceed to the [Usage Guide](./Usage_Guide.md) to start the application.
